/*jshint esversion: 6 */

define(["lodash", "src/utils", "src/math/vec2", "src/math/mat3",
	"lib/box2d/box2d.min",
	],
function (lodash, utils, vec2, mat3,
		  box2d
		 ) {

"use strict";

// Class (ie static) methods for b2Vec2
lodash.extend(box2d.b2Vec2, {
	// Like Array.from, construct b2Vec2 from array.
	from (a) {
		return new box2d.b2Vec2(a[0], a[1]);
	}
});

// Instance methods for b2Vec2
utils.mixin(box2d.b2Vec2, {
	// Return contents of the vector in array.
	// Optionally provide array to avoid allocation.
	asArray (result0) {
		let result = result0 || vec2();
		result.init(this.get_x(), this.get_y());
		return result;
	}
});

return box2d;

}); // end define
